/*=============================================
  Markov.java
  
  Contains instance variables and methods to store a text Markov chain 
  in a map.
  
  Instance Variables:
  Map<String, ArrayList> h
     This is a map where the keys are Strings and the values are ArrayLists
     Each key is a string created by combining two strings
     The ArrayList contains all the single Strings that come directly after
     the key's 2-string combination.
     e.g: If the text is "To be, or not to be, that is the question."
          The first key would be "Tobe," and the associated ArrayList would 
	  contain "or" and "that"
	  Another entry would be "be,or" whose associated ArrayList would
	  contain "not"

  String first, second
     first and second are used in generate to provide the first key used to
     begin the chain. They should be set to the first 2 words entered into 
     the Markov object

  boolean empty
     Boolean variable used to keep track of whether the Markov chain is empty
     useful for setting first and second

  Methods:
  constructor
      Initializes the map (to either a HashMap or TreeMap, both will work)
      Sets empty to true

  void add (String s1, String s2, String s3)
      Uses the combination of s1 and s2 as a key.
      If the Map contains an ArrayList associated with that key, add s3 to
      the end of that ArrayList
      If the Map does not contain an ArrayList associated with that key, 
      create a new ArrayList, add s3 to it and insert it into the Map.
      Remember to set first and second if needed.

  void generate(int size) 
      Prints out size words taken from the Markov chain as follows:
      Start with first and second as the begining, picks one of the words
      associated with that key at random from the ArrayList in the Map. 
      Then uses second and the words picked from the ArrayList as the next key
      and continues on until size words have been selected
  
  void printStats() 
      Traverses the Map, printing each key and its associated ArrayList
      
  void getStarting()
  	  Creates seed Strings for our Markov chain to be used in generate.
  	  It searches for a random key that starts with a capital letter. 
  	  But if it can't find in in a reasonable time, it will just use the 
  	  first two words inserted.
  ===========================================*/
    

import java.io.*;
import java.util.*;

public class Markov {

    Map<String, ArrayList<String>> h;
    String first, second;
    boolean empty;

    public Markov() {

		h = new HashMap<String, ArrayList<String>>();
		//h = new TreeMap<String, ArrayList<String>>();
		empty = true;
    }

    public void add(String s1, String s2, String s3) {

		String key = s1 + " " + s2;
		
		if ( empty ) {
		    first = s1;
		    second = s2;
		    empty = false;
		}
		
		if ( h.containsKey(key ) )
		    h.get( key ).add(s3);
		
		else {
		    ArrayList<String>entry = new ArrayList<String>();
	
		    entry.add( s3 );
		    h.put( key, entry );
		}
    }
  
    public void printStats() {

		Set<String> s = h.keySet();
		Iterator<String> k = s.iterator();
	
		while (k.hasNext() ) {
		    String key = k.next();
		    ArrayList<String> a = h.get(key);
	
		    Iterator<String> e = a.iterator();
	
		    System.out.print(key + "\n\t");
		    while (e.hasNext() )
			System.out.print( e.next() + " ");
		    System.out.println();
		}
    }
    
    public boolean isCapital(char c){
    	return (c <= 'Z') && (c >= 'A');
    }
    
    public String getStarting(){
    	List<String> keys = new ArrayList<String>(h.keySet());
    	
    	int iter = 0;
    	do{
        	int randomKeyIndex = (int)(Math.random() * h.size());
        	
        	String randomKey = keys.get(randomKeyIndex);
        	if( isCapital(randomKey.charAt(0))){
        		return randomKey;
        	}
        	iter ++;
    	} while(iter < 1000);
    	
    	return first + " " + second;
    }
    
    public void generate(int size) {

		String s1, s2, s3;
		ArrayList<String> a;

		String[] start = getStarting().split(" ");
		s1 = start[0];
		s2 = start[1];
		
		System.out.print(s1 + " " + s2 + " ");
		int LineLength = 15;
		int n =0 ;
		for (int i=0; i < size; i++) {
			
		    a = h.get( s1 + " " +s2 );
		    if(a != null){
			    s3 = a.get( (int)(Math.random() * a.size()) );
			    System.out.print( s3 + " ");
			    if(n > LineLength){
			    	System.out.println("");
			    	n = 0;
			    }
			    n++;
			    s1 = s2;
			    s2 = s3;
		    }
		    else{
		    	String[] restart = getStarting().split(" ");
		    	s1 =restart[0];
		    	s2 = restart[1];
		    }

		}
    }
}

				
